/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u0000 \u008b\u00012\u00020\u00012\u00020\u0002:\u0002\u008b\u0001B\u0011\u0012\u0006\u0010\u007f\u001a\u00020\u0002\u00a2\u0006\u0006\b\u0089\u0001\u0010\u008a\u0001J\u0010\u0010\u0004\u001a\u00020\u0003H\u0096\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0005J\u001f\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJC\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\u000b\u001a\u00020\n2\u001c\b\u0002\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f0\u000e2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016Ja\u0010\u0015\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u0017*\u00020\u00112\b\b\u0001\u0010\u000b\u001a\u00020\n2\u001c\b\u0002\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f0\u000e2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\u0004\b\u0015\u0010\u001bJ#\u0010\u0015\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\u0004\b\u0015\u0010\u001dJN\u0010\u0015\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u001e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2#\u0010!\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001f\u00a2\u0006\u0002\b \u00a2\u0006\u0004\b\u0015\u0010\"J\u001b\u0010%\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0#\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010)\u001a\u00020\n2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030'\u00a2\u0006\u0004\b)\u0010*J#\u0010)\u001a\u00020\u00032\n\u0010(\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b-\u0010.J\u0019\u0010/\u001a\u00020\n2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030'\u00a2\u0006\u0004\b/\u0010*J\u0015\u0010/\u001a\u00020\n2\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b/\u00102J\u0015\u00106\u001a\u0002052\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b8\u0010\u0005J\u0015\u00109\u001a\u0002052\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b9\u00107R\u0018\u0010=\u001a\u0006\u0012\u0002\b\u00030:8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R$\u0010?\u001a\u0004\u0018\u00010>8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0017\u0010F\u001a\u00020E8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\"\u0010J\u001a\u0002058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\"\u0010P\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR \u0010W\u001a\b\u0012\u0004\u0012\u00020>0V8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u001b\u0010_\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^R*\u0010b\u001a\u0012\u0012\u0004\u0012\u0002030`j\b\u0012\u0004\u0012\u000203`a8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u0010eR\"\u0010g\u001a\u00020f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u0016\u0010o\u001a\u0004\u0018\u00010\u00008\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR\"\u0010p\u001a\u00020f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010h\u001a\u0004\bq\u0010j\"\u0004\br\u0010lRO\u0010x\u001a6\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020\b0\u000f0sj\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020\b0\u000f`t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bu\u0010\\\u001a\u0004\bv\u0010wR\u001b\u0010{\u001a\u00060yj\u0002`z8\u0006\u00a2\u0006\f\n\u0004\b{\u0010|\u001a\u0004\b}\u0010~R\u0015\u0010\u007f\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u007f\u0010\u0080\u0001R\u0016\u0010\u0082\u0001\u001a\u00020f8\u0016X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010jR+\u0010\u0083\u0001\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001\u00a8\u0006\u008c\u0001"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "", "close", "()V", "closeExecutedStatements", "commit", "", "delta", "", "stmt", "describeStatement", "(JLjava/lang/String;)Ljava/lang/String;", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "args", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "explicitStatementType", "exec", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;)Lkotlin/Unit;", "T", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "transform", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "R", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "body", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "", "stmts", "execInBatch", "(Ljava/util/List;)V", "Lorg/jetbrains/exposed/sql/Column;", "column", "fullIdentity", "(Lorg/jetbrains/exposed/sql/Column;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "fullIdentity$exposed_core", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "identity", "Lorg/jetbrains/exposed/sql/Table;", "table", "(Lorg/jetbrains/exposed/sql/Table;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;", "interceptor", "", "registerInterceptor", "(Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;)Z", "rollback", "unregisterInterceptor", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connection", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "currentStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "Lorg/jetbrains/exposed/sql/Database;", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "debug", "Z", "getDebug", "()Z", "setDebug", "(Z)V", "duration", "J", "getDuration", "()J", "setDuration", "(J)V", "", "executedStatements", "Ljava/util/List;", "getExecutedStatements$exposed_core", "()Ljava/util/List;", "id$delegate", "Lkotlin/Lazy;", "getId", "()Ljava/lang/String;", "id", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "interceptors", "Ljava/util/ArrayList;", "getInterceptors$exposed_core", "()Ljava/util/ArrayList;", "", "openResultSetsCount", "I", "getOpenResultSetsCount$exposed_core", "()I", "setOpenResultSetsCount$exposed_core", "(I)V", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "outerTransaction", "statementCount", "getStatementCount", "setStatementCount", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "statementStats$delegate", "getStatementStats", "()Ljava/util/HashMap;", "statementStats", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "statements", "Ljava/lang/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "transactionImpl", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "getTransactionIsolation", "transactionIsolation", "warnLongQueriesDuration", "Ljava/lang/Long;", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "<init>", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "Companion", "exposed-core"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionInterface transactionImpl;
    @NotNull
    private final Database db;
    private int statementCount;
    private long duration;
    @Nullable
    private Long warnLongQueriesDuration;
    private boolean debug;
    @NotNull
    private final Lazy id$delegate;
    @Nullable
    private PreparedStatementApi currentStatement;
    @NotNull
    private final List<PreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    @NotNull
    private final StringBuilder statements;
    @NotNull
    private final Lazy statementStats$delegate;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public Transaction(@NotNull TransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter((Object)transactionImpl, (String)"transactionImpl");
        this.transactionImpl = transactionImpl;
        this.db = this.transactionImpl.getDb();
        this.warnLongQueriesDuration = this.db.getConfig().getWarnLongQueriesDuration();
        this.id$delegate = LazyKt.lazy((Function0)id.2.INSTANCE);
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        this.statements = new StringBuilder();
        this.statementStats$delegate = LazyKt.lazy((Function0)statementStats.2.INSTANCE);
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        SQLLogKt.addLogger(this, sqlLoggerArray);
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    @Nullable
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    @NotNull
    public final Database getDb() {
        return this.db;
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    @Nullable
    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(@Nullable Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getId() {
        Lazy lazy2 = this.id$delegate;
        return (String)lazy2.getValue();
    }

    @Nullable
    public final PreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable PreparedStatementApi preparedStatementApi) {
        this.currentStatement = preparedStatementApi;
    }

    @NotNull
    public final List<PreparedStatementApi> getExecutedStatements$exposed_core() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_core() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_core(int n) {
        this.openResultSetsCount = n;
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_core() {
        return this.interceptors;
    }

    @NotNull
    public final StringBuilder getStatements() {
        return this.statements;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        Lazy lazy2 = this.statementStats$delegate;
        return (HashMap)lazy2.getValue();
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.remove(interceptor);
    }

    @Override
    public void commit() {
        StatementInterceptor it;
        HashMap dataToStore = new HashMap();
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit();
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit();
        }
        this.getUserdata().putAll(dataToStore);
    }

    @Override
    public void rollback() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback();
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback();
        }
        this.getUserdata().clear();
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take((String)stmt, (int)1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return (Unit)this.exec(stmt, args, explicitStatementType, exec.1.INSTANCE);
    }

    public static /* synthetic */ Unit exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        StatementType statementType;
        block4: {
            Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            if (((CharSequence)stmt).length() == 0) {
                return null;
            }
            if (explicitStatementType == null) {
                for (StatementType statementType2 : StatementType.values()) {
                    StatementType it = statementType2;
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)stmt)).toString(), (String)it.name(), (boolean)true)) continue;
                    statementType = statementType2;
                    break block4;
                }
                statementType = null;
            } else {
                statementType = explicitStatementType;
            }
        }
        Object object = statementType;
        StatementType type = object == null ? StatementType.OTHER : object;
        object = CollectionsKt.emptyList();
        return this.exec(new Statement<T>(type, transform, stmt, args, (List<? extends Table>)object){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
                Object object;
                ResultSet result2;
                ResultSet resultSet;
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: {
                        resultSet = $this$executeInternal.executeQuery();
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        resultSet = $this$executeInternal.getResultSet();
                    }
                }
                ResultSet resultSet2 = result2 = resultSet;
                if (resultSet2 == null) {
                    object = null;
                } else {
                    Object object2;
                    ResultSet resultSet3 = resultSet2;
                    Function1<ResultSet, T> function1 = this.$transform;
                    boolean bl = false;
                    try (ResultSet it = resultSet3;){
                        object2 = function1.invoke((Object)it);
                    }
                    object = object2;
                }
                return (T)object;
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                return this.$stmt;
            }

            @NotNull
            public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
                return CollectionsKt.listOf(this.$args);
            }
        });
    }

    public static /* synthetic */ Object exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull Statement<? extends T> stmt) {
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        return (T)this.exec(stmt, exec.3.INSTANCE);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, (String)"stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull Statement<? extends T> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        Object object;
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int n = this.statementCount;
        this.statementCount = n + 1;
        long start = System.currentTimeMillis();
        Pair<? extends T, List<StatementContext>> answer = stmt.executeIn$exposed_core(this);
        long delta = System.currentTimeMillis() - start;
        Lazy lazySQL2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(answer, this){
            final /* synthetic */ Pair<T, List<StatementContext>> $answer;
            final /* synthetic */ Transaction this$0;
            {
                this.$answer = $answer;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)this.$answer.getSecond();
                Transaction transaction2 = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StatementContext statementContext = (StatementContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.sql(transaction2));
                }
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
            }
        }));
        this.duration += delta;
        if (this.debug) {
            Object object2;
            void $this$getOrPut$iv;
            this.statements.append(this.describeStatement(delta, (String)lazySQL2.getValue()));
            Map map2 = this.getStatementStats();
            Object key$iv = lazySQL2.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Pair answer$iv = TuplesKt.to((Object)0, (Object)0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Pair $dstr$count$time = (Pair)object2;
            boolean bl = false;
            int count2 = ((Number)$dstr$count$time.component1()).intValue();
            long time = ((Number)$dstr$count$time.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazySQL2.getValue(), TuplesKt.to((Object)(count2 + 1), (Object)(time + delta)));
        }
        Long l = this.warnLongQueriesDuration;
        if (delta > (l == null ? Long.MAX_VALUE : l)) {
            SQLLogKt.getExposedLogger().warn(Intrinsics.stringPlus((String)"Long query: ", (Object)this.describeStatement(delta, (String)lazySQL2.getValue())), (Throwable)new RuntimeException());
        }
        Object object3 = answer.getFirst();
        if (object3 == null) {
            object = null;
        } else {
            Object it = object3;
            boolean bl = false;
            object = body.invoke(stmt, it);
        }
        return (R)object;
    }

    @NotNull
    public final String identity(@NotNull Table table) {
        String string;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Alias alias = table instanceof Alias ? (Alias)table : null;
        if (alias == null) {
            string = null;
        } else {
            Alias it = alias;
            boolean bl = false;
            string = this.identity((Table)it.getDelegate()) + ' ' + this.getDb().getIdentifierManager().quoteIfNecessary(it.getAlias());
        }
        String string2 = string;
        return string2 == null ? this.db.getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(table.getTableName())) : string2;
    }

    @NotNull
    public final String fullIdentity(@NotNull Column<?> column) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        QueryBuilder it = queryBuilder = new QueryBuilder(false);
        boolean bl = false;
        this.fullIdentity$exposed_core(column, it);
        return queryBuilder.toString();
    }

    public final void fullIdentity$exposed_core(@NotNull Column<?> column, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(column, this){
            final /* synthetic */ Column<?> $column;
            final /* synthetic */ Transaction this$0;
            {
                this.$column = $column;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                if (this.$column.getTable() instanceof Alias) {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(((Alias)this.$column.getTable()).getAlias()));
                } else {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(this.$column.getTable().getTableName())));
                }
                $this$invoke.append('.');
                $this$invoke.append(this.this$0.identity(this.$column));
            }
        }));
    }

    @NotNull
    public final String identity(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.db.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.getName());
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreparedStatementApi it = (PreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(GlobalStatementInte\u2026::class.java.classLoader)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nR*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/Transaction$Companion;", "", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "globalInterceptors", "Ljava/util/ArrayList;", "getGlobalInterceptors$exposed_core", "()Ljava/util/ArrayList;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors$exposed_core() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

